<?php
/**
 * Plugin Name: SSL Certificate Manager
 * Plugin URI: https://sslmon.net
 * Description: Manage SSL certificates directly from WordPress admin panel. Generate, verify, download, and install SSL certificates automatically.
 * Version: 1.0.0
 * Author: Jagseer Singh
 * Author URI: https://webfusionmasters.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wp-ssl-manager
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('WP_SSL_MANAGER_VERSION', '1.0.0');
define('WP_SSL_MANAGER_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WP_SSL_MANAGER_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WP_SSL_MANAGER_PLUGIN_FILE', __FILE__);

// Include required files
require_once WP_SSL_MANAGER_PLUGIN_DIR . 'includes/class-wp-ssl-manager.php';
require_once WP_SSL_MANAGER_PLUGIN_DIR . 'includes/class-wp-ssl-api.php';
require_once WP_SSL_MANAGER_PLUGIN_DIR . 'includes/class-wp-ssl-cpanel.php';
require_once WP_SSL_MANAGER_PLUGIN_DIR . 'includes/class-wp-ssl-admin.php';

// Initialize the plugin
function wp_ssl_manager_init() {
    $plugin = new WP_SSL_Manager();
    $plugin->run();
}
wp_ssl_manager_init();

