<?php
/**
 * Settings template
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php _e('SSL Certificate Manager - Settings', 'wp-ssl-manager'); ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('wp_ssl_manager_settings'); ?>
        
        <h2><?php _e('API Settings', 'wp-ssl-manager'); ?></h2>
        <p class="description"><?php _e('Enter your API credentials from the SSL Certificate Checker website.', 'wp-ssl-manager'); ?></p>
        
        <table class="form-table">
            <tr>
                <th><label for="wp_ssl_api_url"><?php _e('API URL', 'wp-ssl-manager'); ?> *</label></th>
                <td>
                    <input type="url" id="wp_ssl_api_url" name="wp_ssl_api_url" 
                           value="<?php echo esc_attr(get_option('wp_ssl_api_url', 'https://your-domain.com')); ?>" 
                           class="regular-text" required>
                    <p class="description"><?php _e('Base URL of your SSL Certificate Checker API (e.g., https://your-domain.com)', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="wp_ssl_client_id"><?php _e('Client ID', 'wp-ssl-manager'); ?> *</label></th>
                <td>
                    <input type="text" id="wp_ssl_client_id" name="wp_ssl_client_id" 
                           value="<?php echo esc_attr(get_option('wp_ssl_client_id')); ?>" 
                           class="regular-text" required>
                    <p class="description"><?php _e('Your API Client ID from the SSL Certificate Checker website', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="wp_ssl_client_secret"><?php _e('Client Secret', 'wp-ssl-manager'); ?> *</label></th>
                <td>
                    <input type="password" id="wp_ssl_client_secret" name="wp_ssl_client_secret" 
                           value="<?php echo esc_attr(get_option('wp_ssl_client_secret')); ?>" 
                           class="regular-text" required>
                    <p class="description"><?php _e('Your API Client Secret (stored securely)', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
        </table>
        
        <h2><?php _e('cPanel Settings', 'wp-ssl-manager'); ?></h2>
        <p class="description"><?php _e('Configure cPanel credentials for automatic SSL installation. Leave blank if you don\'t use cPanel.', 'wp-ssl-manager'); ?></p>
        
        <table class="form-table">
            <tr>
                <th><label for="wp_ssl_cpanel_host"><?php _e('cPanel Host', 'wp-ssl-manager'); ?></label></th>
                <td>
                    <input type="text" id="wp_ssl_cpanel_host" name="wp_ssl_cpanel_host" 
                           value="<?php echo esc_attr(get_option('wp_ssl_cpanel_host')); ?>" 
                           class="regular-text" placeholder="cpanel.yourdomain.com">
                    <p class="description"><?php _e('Your cPanel hostname or IP address', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="wp_ssl_cpanel_user"><?php _e('cPanel Username', 'wp-ssl-manager'); ?></label></th>
                <td>
                    <input type="text" id="wp_ssl_cpanel_user" name="wp_ssl_cpanel_user" 
                           value="<?php echo esc_attr(get_option('wp_ssl_cpanel_user')); ?>" 
                           class="regular-text">
                    <p class="description"><?php _e('Your cPanel username', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="wp_ssl_cpanel_pass"><?php _e('cPanel Password', 'wp-ssl-manager'); ?></label></th>
                <td>
                    <input type="password" id="wp_ssl_cpanel_pass" name="wp_ssl_cpanel_pass" 
                           value="<?php echo esc_attr(get_option('wp_ssl_cpanel_pass')); ?>" 
                           class="regular-text">
                    <p class="description"><?php _e('Your cPanel password (stored securely)', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
            <tr>
                <th><label for="wp_ssl_cpanel_port"><?php _e('cPanel Port', 'wp-ssl-manager'); ?></label></th>
                <td>
                    <input type="number" id="wp_ssl_cpanel_port" name="wp_ssl_cpanel_port" 
                           value="<?php echo esc_attr(get_option('wp_ssl_cpanel_port', '2083')); ?>" 
                           class="small-text" min="1" max="65535">
                    <p class="description"><?php _e('cPanel port (default: 2083 for SSL)', 'wp-ssl-manager'); ?></p>
                </td>
            </tr>
        </table>
        
        <?php submit_button(); ?>
    </form>
</div>

