<?php
/**
 * cPanel API integration class
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_SSL_CPanel {
    
    /**
     * Install SSL certificate via cPanel API
     */
    public function install_ssl($domain, $ssl_dir, $cpanel_host, $cpanel_user, $cpanel_pass, $port = '2083') {
        try {
            // Find certificate files
            $cert_file = null;
            $key_file = null;
            $ca_bundle_file = null;
            
            $files = scandir($ssl_dir);
            foreach ($files as $file) {
                if ($file === '.' || $file === '..') {
                    continue;
                }
                
                $file_path = $ssl_dir . '/' . $file;
                if (is_file($file_path)) {
                    if (preg_match('/\.(crt|cert)$/i', $file)) {
                        $cert_file = $file_path;
                    } elseif (preg_match('/\.(key)$/i', $file)) {
                        $key_file = $file_path;
                    } elseif (preg_match('/\.(ca|chain|bundle)$/i', $file)) {
                        $ca_bundle_file = $file_path;
                    }
                }
            }
            
            if (!$cert_file || !$key_file) {
                return array(
                    'success' => false,
                    'message' => __('Certificate or key file not found', 'wp-ssl-manager'),
                );
            }
            
            // Read certificate files
            $certificate = file_get_contents($cert_file);
            $private_key = file_get_contents($key_file);
            $ca_bundle = $ca_bundle_file ? file_get_contents($ca_bundle_file) : '';
            
            // cPanel API URL
            $api_url = 'https://' . $cpanel_host . ':' . $port . '/execute/SSL/install_ssl';
            
            // Prepare request
            $auth = base64_encode($cpanel_user . ':' . $cpanel_pass);
            
            $body = array(
                'domain' => $domain,
                'cert' => $certificate,
                'key' => $private_key,
            );
            
            if ($ca_bundle) {
                $body['cabundle'] = $ca_bundle;
            }
            
            $response = wp_remote_post($api_url, array(
                'headers' => array(
                    'Authorization' => 'Basic ' . $auth,
                    'Content-Type' => 'application/x-www-form-urlencoded',
                ),
                'body' => http_build_query($body),
                'timeout' => 30,
                'sslverify' => false, // cPanel often uses self-signed certs
            ));
            
            if (is_wp_error($response)) {
                return array(
                    'success' => false,
                    'message' => $response->get_error_message(),
                );
            }
            
            $response_body = json_decode(wp_remote_retrieve_body($response), true);
            $status_code = wp_remote_retrieve_response_code($response);
            
            if ($status_code === 200 && isset($response_body['status']) && $response_body['status'] === 1) {
                return array(
                    'success' => true,
                    'message' => __('SSL certificate installed successfully', 'wp-ssl-manager'),
                );
            } else {
                $error_message = isset($response_body['errors']) ? implode(', ', $response_body['errors']) : 'Installation failed';
                return array(
                    'success' => false,
                    'message' => $error_message,
                );
            }
            
        } catch (Exception $e) {
            return array(
                'success' => false,
                'message' => $e->getMessage(),
            );
        }
    }
    
    /**
     * Alternative method using cPanel UAPI
     */
    public function install_ssl_uapi($domain, $ssl_dir, $cpanel_host, $cpanel_user, $cpanel_pass, $port = '2083') {
        try {
            // Find certificate files
            $cert_file = null;
            $key_file = null;
            $ca_bundle_file = null;
            
            $files = scandir($ssl_dir);
            foreach ($files as $file) {
                if ($file === '.' || $file === '..') {
                    continue;
                }
                
                $file_path = $ssl_dir . '/' . $file;
                if (is_file($file_path)) {
                    if (preg_match('/\.(crt|cert)$/i', $file)) {
                        $cert_file = $file_path;
                    } elseif (preg_match('/\.(key)$/i', $file)) {
                        $key_file = $file_path;
                    } elseif (preg_match('/\.(ca|chain|bundle)$/i', $file)) {
                        $ca_bundle_file = $file_path;
                    }
                }
            }
            
            if (!$cert_file || !$key_file) {
                return array(
                    'success' => false,
                    'message' => __('Certificate or key file not found', 'wp-ssl-manager'),
                );
            }
            
            // Read certificate files
            $certificate = file_get_contents($cert_file);
            $private_key = file_get_contents($key_file);
            $ca_bundle = $ca_bundle_file ? file_get_contents($ca_bundle_file) : '';
            
            // cPanel UAPI URL
            $api_url = 'https://' . $cpanel_host . ':' . $port . '/execute/SSL/install_ssl';
            
            // Prepare request
            $auth = base64_encode($cpanel_user . ':' . $cpanel_pass);
            
            $body = array(
                'domain' => $domain,
                'cert' => $certificate,
                'key' => $private_key,
            );
            
            if ($ca_bundle) {
                $body['cabundle'] = $ca_bundle;
            }
            
            $response = wp_remote_post($api_url, array(
                'headers' => array(
                    'Authorization' => 'Basic ' . $auth,
                    'Content-Type' => 'application/x-www-form-urlencoded',
                ),
                'body' => http_build_query($body),
                'timeout' => 30,
                'sslverify' => false,
            ));
            
            if (is_wp_error($response)) {
                return array(
                    'success' => false,
                    'message' => $response->get_error_message(),
                );
            }
            
            $response_body = json_decode(wp_remote_retrieve_body($response), true);
            $status_code = wp_remote_retrieve_response_code($response);
            
            if ($status_code === 200) {
                return array(
                    'success' => true,
                    'message' => __('SSL certificate installed successfully', 'wp-ssl-manager'),
                );
            } else {
                $error_message = isset($response_body['errors']) ? implode(', ', $response_body['errors']) : 'Installation failed';
                return array(
                    'success' => false,
                    'message' => $error_message,
                );
            }
            
        } catch (Exception $e) {
            return array(
                'success' => false,
                'message' => $e->getMessage(),
            );
        }
    }
}

